<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}

class CGalleryWidgetImagesWCarousel extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "1",
		"name"	=> "Images w/ Carousel",
	);


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {

		switch ($widget["settings"]["set_order"]) {
			case "1":
				$order = " rand() ";
			break;

			default:
			case "2":
				$order = " r.item_id DESC ";
			break;
			
			case "3":
				$order = " r.item_id ASC ";
			break;
		}

		if ($widget["settings"]["set_album_items"] && $widget["settings"]["set_album"]) {
			$cond = " AND c.cat_id in(" . $widget["settings"]["set_album"] . ") " ; 
		}
		

		
		$photos = $this->plugins["media"]->Gallery(
			$widget["settings"]["set_album_items"] && $widget["settings"]["set_album"] ? explode("," , $widget["settings"]["set_album"]) : "" , 
			$widget["mod_id"] , 
			"",
			"",
			"array",
			array(
				"path"	=> "upload/gallery",
				"tn"	=> $widget["settings"]["set_height"] ? "tn" : "tn2",
				"order"	=> $order,
				"max"	=> max(1, $widget["settings"]["set_items"]),
			)
		);


		if (is_Array($photos)) {

			global $base;

			return $this->tpl->blockReplace(
				"Main" , 
				array(
					"images"	=> $base->html->Table(
						$this->tpl , 
						"",
						$photos
					),


					"filter"	=> $this->Filter($widget, $photos),

					"class"	=> $this->tpl->blockreplace($widget["settings"]["set_carousel"] ? "Carousel" :"List"),


					"thumbs"	=> $widget["settings"]["set_carousel_thumbs"] ? $base->html->table(
						$this->tpl,
						"Thumbs",
						$photos
					) : ""

				),
				$widget["settings"],
				$widget
			);

			
		}
		
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Filter($widget , $photos) {
		global $base;

		if (!$widget["settings"]["set_filter"]) {
			return "";
		}

		if ($widget["settings"]["set_carousel"]) {
			return "";
		}

		//check to see if there are aty least 2 categories
		foreach ($photos as $key => $val) {
			$pids[$val["parent"]] = $val["parent"];
		}

		if (count($pids) < 2) {
			return "";
		}

		//read all categories
		$cats = $this->db->QFetchRowArray(
			"SELECT * " . 
			"FROM 
				{$this->tables['plugin:gallery_cats']} as c,
				{$this->tables['plugin:gallery_cats_lang']} as l
			WHERE 				
				c.cat_id=l.cat_id AND 
				l.lang_id={$widget[lang_id]} AND 
				c.cat_status = 1 AND c.cat_date <= %d AND 
				c.cat_id in (%s)
			ORDER BY  
				cat_order ASC 
			",
			array(
				time(),
				implode("," , $pids)
			)
		);

		if (is_array($cats)) {
			return $base->html->table(
				$this->tpl,
				"Cats",
				$cats,
				$widget["mod_settings"]
			);
		}
				
	}
	
	

}


?>